/* ============ */
/* GapMnSd.c	*/
/* ============ */
#include <defcodes.h>
#include <math.h>
/* ==================================================================== */
/* CalcGapMeanStdDev - Calculates Mean & Standard Deviation for Gap Test*/
/* ==================================================================== */
void
CalcGapMeanStdDev(int NumGaps, double BaseProb, double *Mean,
		double *StdDev)
{
    /* ---------------------------------------------------- */
    /* NumGaps  (IN)  - Number of Gaps to be Tabulated	    */
    /* BaseProb (IN)  - Probability Measure (GapHi-GapLo)   */
    /* Mean     (OUT) -	Average Number of Variates Required */
    /* StdDev   (OUT) - Corresponding Standard Deviation    */
    /*							    */
    /* These equations were taken from Knuth, Vol 2, p 535  */
    /* ---------------------------------------------------- */
    *Mean = NumGaps/BaseProb;

    *StdDev = sqrt(NumGaps * (1-BaseProb)) / BaseProb;
}
